package com.example.sefinsa_app.models;

import android.os.Parcel;
import android.os.Parcelable;

public class Aval implements Parcelable {

    public String id, nombre_completo, direccion, telefono, garantias, carpeta_comprobantes, carpeta_garantias,
            otras_referencias, created_at, updated_at, ruta_id, poblacion_id, colocadora_id, update_comprobantes_Enaval, update_garantias_Enaval;


    // Constructor con todos los parámetros
    public Aval(String id, String nombre_completo, String direccion, String telefono,
                String garantias, String carpeta_comprobantes, String carpeta_garantias,
                String otras_referencias, String created_at, String updated_at, String ruta_id, String poblacion_id, String colocadora_id, String update_comprobantes_Enaval, String update_garantias_Enaval) {
        this.id = id;
        this.nombre_completo = nombre_completo;
        this.direccion = direccion;
        this.telefono = telefono;
        this.garantias = garantias;
        this.carpeta_comprobantes = carpeta_comprobantes;
        this.carpeta_garantias = carpeta_garantias;
        this.otras_referencias = otras_referencias;
        this.created_at = created_at;
        this.updated_at = updated_at;
        this.ruta_id = ruta_id;
        this.poblacion_id = poblacion_id;
        this.colocadora_id = colocadora_id;
        this.update_comprobantes_Enaval = update_comprobantes_Enaval;
        this.update_garantias_Enaval = update_garantias_Enaval;
    }

    // Constructor para leer desde el Parcel
    protected Aval(Parcel in) {
        id = in.readString();
        nombre_completo = in.readString();
        direccion = in.readString();
        telefono = in.readString();
        garantias = in.readString();
        carpeta_comprobantes = in.readString();
        carpeta_garantias = in.readString();
        otras_referencias = in.readString();
        created_at = in.readString();
        updated_at = in.readString();
        ruta_id = in.readString();
        poblacion_id = in.readString();
        colocadora_id = in.readString();
        update_comprobantes_Enaval = in.readString();
        update_garantias_Enaval = in.readString();
    }

    public Aval(String id, String nombre_completo) {
        this.id = id;
        this.nombre_completo = nombre_completo;
    }

    public Aval(String id, String nombre_completo, String direccion, String telefono, String garantias, String otras_referencias, String ruta_id, String poblacion_id, String colocadora_id) {
        this.id = id;
        this.nombre_completo = nombre_completo;
        this.direccion = direccion;
        this.telefono = telefono;
        this.garantias = garantias;
        this.otras_referencias = otras_referencias;
        this.ruta_id = ruta_id;
        this.poblacion_id = poblacion_id;
        this.colocadora_id = colocadora_id;
    }

    public Aval() {

    }

    // Método describeContents, generalmente retorna 0
    @Override
    public int describeContents() {
        return 0;
    }

    // Escribir los datos de Aval en el Parcel
    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(id);
        dest.writeString(nombre_completo);
        dest.writeString(direccion);
        dest.writeString(telefono);
        dest.writeString(garantias);
        dest.writeString(carpeta_comprobantes);
        dest.writeString(carpeta_garantias);
        dest.writeString(otras_referencias);
        dest.writeString(created_at);
        dest.writeString(updated_at);
        dest.writeString(ruta_id);
        dest.writeString(poblacion_id);
        dest.writeString(colocadora_id);
        dest.writeString(update_comprobantes_Enaval);
        dest.writeString(update_garantias_Enaval);
    }

    // CREATOR para crear instancias de Aval desde el Parcel
    public static final Parcelable.Creator<Aval> CREATOR = new Parcelable.Creator<Aval>() {
        @Override
        public Aval createFromParcel(Parcel in) {
            return new Aval(in);
        }

        @Override
        public Aval[] newArray(int size) {
            return new Aval[size];
        }
    };

    // Getters y Setters (si los necesitas)
    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getNombre_completo() {
        return nombre_completo;
    }

    public void setNombre_completo(String nombre_completo) {
        this.nombre_completo = nombre_completo;
    }

    public String getDireccion() {
        return direccion;
    }

    public void setDireccion(String direccion) {
        this.direccion = direccion;
    }

    public String getTelefono() {
        return telefono;
    }

    public void setTelefono(String telefono) {
        this.telefono = telefono;
    }

    public String getGarantias() {
        return garantias;
    }

    public void setGarantias(String garantias) {
        this.garantias = garantias;
    }

    public String getRuta_id() {
        return ruta_id;
    }

    public void setRuta_id(String ruta_id) {
        this.ruta_id = ruta_id;
    }

    public String getPoblacion_id() {
        return poblacion_id;
    }

    public void setPoblacion_id(String poblacion_id) {
        this.poblacion_id = poblacion_id;
    }

    public String getColocadora_id() {
        return colocadora_id;
    }

    public void setColocadora_id(String colocadora_id) {
        this.garantias = colocadora_id;
    }

    public String getCarpeta_comprobantes() {
        return carpeta_comprobantes;
    }

    public void setCarpeta_comprobantes(String carpeta_comprobantes) {
        this.carpeta_comprobantes = carpeta_comprobantes;
    }

    public String getCarpeta_garantias() {
        return carpeta_garantias;
    }

    public void setCarpeta_garantias(String carpeta_garantias) {
        this.carpeta_garantias = carpeta_garantias;
    }

    public String getOtras_referencias() {
        return otras_referencias;
    }

    public void setOtras_referencias(String otras_referencias) {
        this.otras_referencias = otras_referencias;
    }

    public String getCreated_at() {
        return created_at;
    }

    public void setCreated_at(String created_at) {
        this.created_at = created_at;
    }

    public String getUpdated_at() {
        return updated_at;
    }

    public String getUpdate_garantias_Enaval() {
        return update_garantias_Enaval;
    }
    public void setUpdate_garantias_Enaval(String update_garantias_Enaval) {
        this.update_garantias_Enaval = update_garantias_Enaval;
    }
    public String getUpdate_comprobantes_Enaval() {
        return update_comprobantes_Enaval;
    }
    public void setUpdate_comprobantes_Enaval(String update_comprobantes_Enaval) {
        this.update_comprobantes_Enaval = update_comprobantes_Enaval;
    }

    public void setUpdated_at(String updated_at) {
        this.updated_at = updated_at;
    }

    @Override
    public String toString() {
        return "Aval{" +
                "id='" + id + '\'' +
                ", nombre_completo='" + nombre_completo + '\'' +
                ", direccion='" + direccion + '\'' +
                ", telefono='" + telefono + '\'' +
                ", garantias='" + garantias + '\'' +
                ", carpeta_comprobantes='" + carpeta_comprobantes + '\'' +
                ", carpeta_garantias='" + carpeta_garantias + '\'' +
                ", otras_referencias='" + otras_referencias + '\'' +
                ", created_at='" + created_at + '\'' +
                ", updated_at='" + updated_at + '\'' +
                ", ruta_id='" + ruta_id + '\'' +
                ", poblacion_id='" + poblacion_id + '\'' +
                ", colocadora_id='" + colocadora_id + '\'' +
                '}';
    }



    // Método para convertir a JSON si lo necesitas
    public String toJSON() {
        return "{" +
                "'id':'" + id + '\'' +
                ", 'nombre_completo':'" + nombre_completo + '\'' +
                ", 'direccion':'" + direccion + '\'' +
                ", 'telefono':'" + telefono + '\'' +
                ", 'garantias':'" + garantias + '\'' +
                ", 'carpeta_comprobantes':'" + carpeta_comprobantes + '\'' +
                ", 'carpeta_garantias':'" + carpeta_garantias + '\'' +
                ", 'otras_referencias':'" + otras_referencias + '\'' +
                ", 'created_at':'" + created_at + '\'' +
                ", 'updated_at':'" + updated_at + '\'' +
                ", 'ruta_id':'" + ruta_id + '\'' +
                ", 'poblacion_id':'" + poblacion_id + '\'' +
                ", 'colocadora_id':'" + colocadora_id + '\'' +
                '}';
    }


}
